% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StepGraph.R
\name{StepGraph}
\alias{StepGraph}
\title{Stepwise Gaussian Graphical Model}
\usage{
StepGraph(x, alpha_f, alpha_b, nei.max)
}
\arguments{
\item{x}{Data matrix (of size n x p).}

\item{alpha_f}{Forward threshold.}

\item{alpha_b}{Backward threshold.}

\item{nei.max}{Maximum number of variables in every neighborhood.}
}
\value{
A list with the values: \cr \cr
\code{Edges_A}: Estimated set of edges, \cr \cr
\code{Omega}: Estimated precision matrix, \cr \cr
\code{Adj_mat}: A (p x p) zero diagonal matrix. The non-zero off-diagonal elements
corresponds with the order in which the ordered pair (i,j) is selected in the
forward step, and \cr \cr
\code{k_stop}:  Final step in the iteration.
}
\description{
\code{StepGraph} computes the output for the stepwise gaussian graphical algorithm.
}
\author{
Anthony-Alexander Christidis, \email{anthony.christidis@stat.ubc.ca}
}
