# ===============================================
# 
# Classification Performance Script
# 
# The "Numerical.Performance" function computes:
#  - the Frobenius norm
#  - Kullback-Leibler divergence
#  - normalized Kullback- Leibler divergence
# 
# ===============================================

# Numerical Performance
Numerical.Performance = function(x,omega){
  
  # Make Omega Positive Definite
  
  lambda_min = eigen(x)$values[p]
  if (lambda_min < 1e-6){x = x+(0.1+abs(lambda_min))*diag(p)}
  
  x = cov2cor(x)
  sigma = solve(omega)
  
  p = dim(omega)[2]
  
  LRT = (0.5)*((sum(diag(x %*% sigma)) - log(det(x %*% sigma)) - p))
  NLRT=LRT/(1+LRT)
  mse = norm(x - omega,"F")
  #spectral = norm(x - omega,"2")
  
  return(c(LRT,mse,NLRT))
}