# ========================================
# 
# Classification Performance Script
# 
# The "performance" function computes:
#  - sensitivity
#  - specificity
#  - Matthews correlation coefficient
# 
# ========================================

# Classification Performance
performance = function(x, omega){
  
  p = ncol(omega)
  
  x = x - diag(diag(x))
  
  omega = omega - diag(diag(omega))
  
  # True detected Edges
  
  true.adj=abs(omega)>1e-5
  
  ##total number of TRUE edges detected
  
  total_TRUE_edges = sum(true.adj==1)/2 
  
  ##total number of TRUE not edges detected
  
  total_TRUE_not_edges = sum(true.adj==0)/2
  
  # Detected Edges in Simulation
  
  fit.adj=abs(x)>1e-5
  
  ##total number of true edges detected
  
  true_positives = sum(fit.adj[true.adj==1]==1)/2 
  
  ##total number of false edges detected
  
  false_negatives = sum(fit.adj[true.adj==1]==0)/2
  
  false_positives = sum(fit.adj==1)/2 - true_positives
  
  total_FIT_not_edges = sum(fit.adj==0)/2
  
  true_negatives = total_FIT_not_edges - false_negatives
  
  sensitivity = (true_positives)/(total_TRUE_edges)
  
  specificity = (true_negatives)/(total_TRUE_not_edges)
  
  type_one = (false_positives)/(total_TRUE_not_edges)
  
  type_two = (false_negatives)/(total_TRUE_edges)
  
  MCC = ((true_positives*true_negatives)-(false_positives*false_negatives))/
    ((true_positives+false_positives)*(true_positives+false_negatives)*
       (true_negatives+false_positives)*(true_negatives+false_negatives))^0.5
  
  FNR = false_negatives/total_TRUE_edges
  
  FPR = false_positives/(p*(p-1)/2-total_TRUE_edges)
  
  return(c(specificity,sensitivity,MCC,type_one,type_two))
}
