function [f, g, h] = Funct_ObjGradHessian_V_Sparsity_Depth(X, Xt, V, R, Shift, ShiftT, zeta, rho_depth, U)
%==========================================================================
% This function computes the function value, Euclidean gradient and Hessian
% of the objective function (wrt V) in computing (polished) sparsity depth
%------------------------ Input Variables ---------------------------------
% X               - design matrix
% Xt              - transpose of X
% V               - current point V 
% R               - residual matrix
% zeta            - annealing parameter for the heating oprocess (inverse cooling), which controls
%                   the steepness of the function in approximating the sign function 
% L               - lipschitz constant
% U               - direction U of interest
% Shift           - (gamma - s).'*ones(n,1)/n
% rho_depth       - a scaling parameter used in sparsity depth 
%------------------------ Output Variables ---------------------------------
% f               - objective function value
% g               - euclidean gradient
% h 	          - euclidean hessian along U
%==========================================================================
%Xdiag = diag(X*V*Rt);        %This is not efficient!
%Xdiag = diagonal(X,V,Rt);    %Much faster than the first one but not
%efficient enough.
Xdiag =  (1 / rho_depth) * (X*V).*R + Shift * V;
switch nargout
    case 1
        [f1] = aux_Phi(Xdiag, zeta);
        f = sum(f1);
    case 2 % gradient required
        [f1,g1] = aux_Phi(Xdiag, zeta);
        f = sum(f1);
        g = (1 / rho_depth) * Xt * bsxfun(@times, R, g1) + ShiftT * g1; %X.'*diag(g1)*R + ShiftT*g1;
    case 3 % Hessian required
        [f1,g1,h1] = aux_Phi(Xdiag, zeta);
        f = sum(f1);
        g = (1 / rho_depth) * Xt * bsxfun(@times, R, g1) + ShiftT * g1;
        h2 = h1.*(sum(((1 / rho_depth) * X * U).*R, 2) + Shift*U);
        h = (1 / rho_depth) * Xt * bsxfun(@times, R, h2) + ShiftT * h2;  
end
end

