function [val] = Funct_GLM_mean(theta, family)
%==========================================================================
% This function computes mean of GLM
%------------------------ Input Variables ---------------------------------
% theta           - the result of X*B
% family          - GLM family, gaussian or poisson
%------------------------ Output Variables --------------------------------
% val             - the mean of GLM
%==========================================================================
switch lower(family)
   case 'binomial'
      val = 1./(1+exp(-theta)); 
   case 'poisson'
      val = exp(theta);
   case 'gaussian'
      val = theta;
   otherwise
      error('not implemented yet')
end
end