%% This is a demo for computing sparsity data depth 
% We generate some simulation data, use a sparsity-based learning method to
% obtain some estimates, and then calculate the sparsity depth for each estimate. 
% The main step is the calling of function Func_Sparsity_Depth

clear; close all; clc;
addpath(genpath(pwd))

rng('default')
rng(0)

lossType = 'gaussian';

%% Specify simulation parameters
n = 100;
p = 10;
designcorr = .2; 
betaTrue_card = 3;
betaTrue_strenth = 1;
% Data Generation 
X = randn(n, p);
corrMat = designcorr .^ abs([1:p]' * ones(1, p) - ones(p, 1) * [1:p]); 
X = X * chol(corrMat);
betaTrue = betaTrue_strenth * ones(betaTrue_card,1);  betaTrue = [betaTrue; zeros(p - numel(betaTrue), 1)];
y = X * betaTrue(1:end,:) + 1 * randn(n, 1);

fprintf('================================================================================  \n')
% Specify the sparsity level
q = 5;  
disp(['The sparsity level q is set as ', num2str(q)])
fprintf('================================================================================  \n')                
% Try the first beta
subset = [1:q];  
disp(['Trying the restricted-ols est with predictors ', num2str(subset)])
X_sub = X(:, subset); 
betaTarget = zeros(p, 1);
betaTarget(subset) = (X_sub' * X_sub) \ (X_sub' * y); 
[V, S, depthval] = Func_Sparsity_Depth(X, y, betaTarget, 'quantile', q, lossType, [], [], [], [],[]); % the parameters zetaGrid, optsBCD, optsV, optsS, rho_depth take the default
fprintf('%d-sparsity depth for this beta is %.4f \n', q, depthval);
fprintf('================================================================================  \n')

% Try another beta
subset = [1:3, (p-q+4) : p];  
disp(['Trying the restricted-ols est with predictors ', num2str(subset)])
X_sub = X(:, subset); 
betaTarget = zeros(p, 1);
betaTarget(subset) = (X_sub' * X_sub) \ (X_sub' * y); 
[V, S, depthval] = Func_Sparsity_Depth(X, y, betaTarget, 'quantile', q, lossType, [], [], [], [],[]); % the parameters zetaGrid, optsBCD, optsV, optsS, rho_depth take the default
fprintf('%d-sparsity depth for this beta is %.4f \n', q, depthval);
fprintf('================================================================================  \n')

% Try another beta
subset = [1:2, (p-q+1) : p];  
disp(['Trying the restricted-ols est with predictors ', num2str(subset)])
X_sub = X(:, subset); 
betaTarget = zeros(p, 1);
betaTarget(subset) = (X_sub' * X_sub) \ (X_sub' * y); 
[V, S, depthval] = Func_Sparsity_Depth(X, y, betaTarget, 'quantile', q, lossType, [], [], [], [],[]); % the parameters zetaGrid, optsBCD, optsV, optsS, rho_depth take the default
fprintf('%d-sparsity depth for this beta is %.4f \n', q, depthval);
fprintf('================================================================================  \n')
