function [V, final_cost, info] = aux_sparsity_depth_BCD_V(X, Xt, initV, R, Shift, ShiftT, zeta, opts, rho_depth)
%==========================================================================
% This function performs the V-block optimization in calculating sparsity depth.
% It can be viewed as a unconstrained optimization problem on manifolds.
%==========================================================================
% Shift = (gamma - s).'*ones(n,1)/n

[p,m] = size(initV);
% Create the problem structure.
manifold = spherefactory(p,m);
problem.M = manifold;

% Define the problem cost function and its Euclidean gradient.
problem.cost  = @(V) cost(X, Xt, V, R, Shift, ShiftT, zeta, rho_depth);

problem.egrad = @(V) egrad(X, Xt, V, R, Shift, ShiftT, zeta, rho_depth);

if isfield(opts, 'usehess') && strcmpi(opts.usehess, 'TRUE')
    problem.ehess = @(V,U) ehess(X, Xt, V, R, Shift, ShiftT, zeta, rho_depth, U);
end

if isfield(opts, 'checkgrad') && strcmpi(opts.checkgrad, 'TRUE')
    % Numerically check gradient consistency (optional).
    fprintf('=====================================================\n')
    fprintf('Checking Gradient.\n')
    checkgradient(problem);
end

if isfield(opts, 'usehess') && isfield(opts, 'checkhess') && strcmpi(opts.checkhess, 'TRUE')
    fprintf('=====================================================\n')
    fprintf('Checking Hessian.\n')
    checkhessian(problem);
end

switch opts.method
    case 'trustregion'
        [V, final_cost, info, ~] = trustregions(problem, initV, opts);
    otherwise
        error('Please specify the method for manifold optimization.')
end
end

%% Define the objective function value, euclidean grad and euclidean hessian
function [f] = cost(X,Xt,V,R,Shift, ShiftT,zeta, rho_depth)
[f] = Funct_ObjGradHessian_V_Sparsity_Depth(X, Xt, V, R, Shift, ShiftT, zeta, rho_depth);
end

function [g] = egrad(X,Xt,V,R, Shift,ShiftT,zeta, rho_depth)
[~,g] = Funct_ObjGradHessian_V_Sparsity_Depth(X, Xt, V, R, Shift, ShiftT,zeta, rho_depth);
end

function [h] = ehess(X,Xt,V,R, Shift, ShiftT, zeta, rho_depth,U)
[~,~,h] = Funct_ObjGradHessian_V_Sparsity_Depth(X,Xt,V,R, Shift, ShiftT, zeta, rho_depth, U);
end




