function [depth_polished_zeta, depth01, objvec] = Funct_Obj_RRR_Depth(X, V, R, P_perp, L, Q_perp, zeta, rho_depth, depthchoice)
%==========================================================================
% This function computes the polished RRR depth value and the 0-1 depth
% depthchoice: 0: polished depth only; 1: 01 depth only; 2: both.
%==========================================================================

if ~exist('depthchoice', 'var') || isempty('depthchoice')
    depthchoice = 2;
end
[objvec] = aux_Obj_RRR_Depth_objvec(X, V, R, P_perp, L, Q_perp, rho_depth);

depth_polished_zeta = []; depth01 = [];

if depthchoice == 0 || depthchoice == 2
    depth_polished_zeta = sum(aux_Phi(objvec, zeta)) / (2 * size(X, 1)) + 0.5;
end
if depthchoice == 1 || depthchoice == 2
	depth01 = sum((objvec >= 0)) / size(X, 1);
end

end