function [f,g,h] = aux_Phi(X,zeta)
%==========================================================================
% tanh(kx) is used for the approximation of the sign function
% This function computes the first and second derivatives of tanh(kx)
% zeta is the annealing parameter for the progressive optimization (inverse cooling),
% which controls the steepness of the function in approximating the sign function.
%==========================================================================
shift = 1e-6;
f = tanh(zeta*(X+shift)); % vector
if nargout > 1 % gradient required
    g = zeta*(1 - f.^2); %zeta*(sech(zeta*X)).^2;
    if nargout > 2 % Hessian required
        h = -2*zeta*f.*g;
    end
end
end

