function [f,g] = Funct_ObjGrad_B(X, Xt, V, B, R, zeta, fHandle_GLM_res, ZeroOut)
%==========================================================================
% This function computes the objective function value of polished data depth 
% and if necessary, its Euclidean gradient with respect 
% to B to be used in the *nested algorithm* to find a deep B. See the paper for more details.
%------------------------ Input Variables ---------------------------------
% X               - design matrix
% Xt              - transpose of X
% V               - current point V
% B               - the fitted coefficient matrix
% zeta            - annealing parameter for the heating oprocess (inverse cooling), which controls
%                   the steepness of the function in approximating the sign function 
% fHandle_GLM_res - The function handle of Funct_GLMResidual_Gradient.m
% ZeroOut         - field mat: a binary matrix of the same size of B. 0 means the position should be fixed at 0
%------------------------ Output Variables ---------------------------------
% f               - function value
% g               - gradient with respect to B
%==========================================================================

if ~exist('ZeroOut', 'var')
    ZeroOut =[];
end
ZeroOutEffective = exist('ZeroOut', 'var') && ~isempty(ZeroOut);

if ~ZeroOutEffective % ~exist('ZeroOut', 'var') || isempty(ZeroOut)
    if nargout == 1
        if isempty(R)
            [R, ~] = fHandle_GLM_res(X, B);
        end    
    %     Xdiag =  sum((X*V).*R, 2);
    %     [f1, ~] = aux_Phi(Xdiag, zeta);    %f1 is the orginal depth
    %     f = sum(f1);

        [f] = Funct_ObjGradHessian_V(X, Xt, V, R, zeta); 

    elseif nargout == 2

        [R0, G] = fHandle_GLM_res(X, B);

        if isempty(R)
            R = R0;
        else % R is provided, but must equal R0
            if max(max(abs(R0 - R))) > 1e-2
                error('The arugment R is possibly wrong.');
            end     
        end    
        XV = X * V;
        Xdiag =  sum(XV.*R, 2); % diag( X * V * R')
        [f1, g1] = aux_Phi(Xdiag, zeta);    %f1 is the orginal depth
        f = sum(f1);
        g = Xt * (G .* bsxfun(@times, XV, g1));
        
    %     [f, g] = Funct_ObjGradHessian_V(X, Xt, V, R, zeta, []); % no need of U
    end
else % if ZeroOut is not empty, we typically use the *penalized* way to enforce the zeros. 
    
     if strcmpi(ZeroOut.BMethod, 'penalized')
%     	lambda_B = 1e8;
        if isempty(ZeroOut.lambda_B), error(' Penalty parameter on B not provided'), end
        if nargout == 1
            if isempty(R)
                [R, ~] = fHandle_GLM_res(X, B);
            end
    %         [f] = Funct_ObjGradHessian_V(X, Xt, V, R, zeta);

            Xdiag =  sum((X*V).*R, 2); % diag( X * V * R')
            [f1, ~] = aux_Phi(Xdiag, zeta);    %f1 is the orginal depth
            f = sum(f1) + ZeroOut.lambda_B * norm(B .* (~ZeroOut.mat), 'fro')^ 2 / 2;

        elseif nargout == 2

            [R0, G] = fHandle_GLM_res(X, B);

            if isempty(R)
                R = R0;
            else % R is provided, but must equal R0
                if max(max(abs(R0 - R))) > 1e-2
                    error('The arugment R is possibly wrong.');
                end     
            end    
            XV = X * V;
            Xdiag =  sum(XV.*R, 2); % diag( X * V * R')
            [f1, g1] = aux_Phi(Xdiag, zeta);    %f1 is the orginal depth
            f = sum(f1) + ZeroOut.lambda_B * norm(B .* (~ZeroOut.mat), 'fro')^ 2 / 2;
            g = Xt * (G .* bsxfun(@times, XV, g1)) + ZeroOut.lambda_B * (B .* (~ZeroOut.mat));

        %     [f, g] = Funct_ObjGradHessian_V(X, Xt, V, R, zeta, []); % no need of U
        end
     elseif strcmpi(ZeroOut.BMethod, 'constrained')
        
        if nargout == 1
            if isempty(R)
                [R, ~] = fHandle_GLM_res(X, B .* ZeroOut.mat);
            end    
        %     Xdiag =  sum((X*V).*R, 2);
        %     [f1, ~] = aux_Phi(Xdiag, zeta);    %f1 is the orginal depth
        %     f = sum(f1);

            [f] = Funct_ObjGradHessian_V(X, Xt, V, R, zeta); 

        elseif nargout == 2

            [R0, G] = fHandle_GLM_res(X, B .* ZeroOut.mat);
            
            if isempty(R)
                R = R0;
            else % R is provided, but must equal R0
                if max(max(abs(R0 - R))) > 1e-2
                    error('The arugment R is possibly wrong.');
                end     
            end    
            XV = X * V;
            Xdiag =  sum(XV.*R, 2); % diag( X * V * R')
            [f1, g1] = aux_Phi(Xdiag, zeta);    % g1 is derivative of phi
            f = sum(f1);
            g = Xt * (G .* bsxfun(@times, XV, g1));
            g = g .* ZeroOut.mat;   
        %     [f, g] = Funct_ObjGradHessian_V(X, Xt, V, R, zeta, []); % no need of U
        end
     else
         error('Not implemented')
     end
end
end
