function [val] = Funct_GLM_link(y, family)
%==========================================================================
% This function computes link function of GLM for certain family
%------------------------ Input Variables ---------------------------------
% y               - the observations
% family          - GLM family, gaussian or poisson
%------------------------ Output Variables --------------------------------
% val             - the mean of GLM
%==========================================================================
switch lower(family)
   case 'binomial'
      val = log(y./(1-y));
      val(val==-inf) = -1e2;
      val(val==inf) = 1e2;      
   case 'poisson'
      val = log(y);
   case 'gaussian'
      val = y;
   otherwise
      error('not implemented yet')
end
end