function [V] = Funct_SPCA_V(Xt, R, way )
%==========================================================================
% This function performs spherical pca to get the leading direction V
%------------------------ Input Variables ---------------------------------
% Xt              - transpose X (p x n)
% R               - residual matrix (n x m)
%------------------------ Output Variables ---------------------------------
% V               - the leading S-PCA direction
%==========================================================================

X = Xt';
[n, p] = size(X);
[~, m] = size(R);

if ~exist('way', 'var') | isempty(way) 
    way = 1;
end


if way == 1
    %%%%%%method 1%%%%%
    temp_x = repmat(X,1,m);
    temp_r = kron(R,ones(1,p));
    temp_xr = temp_x .* temp_r;
elseif way == 2 
    %%%%%%method 2%%%%%
    XR = [R,X];
    temp_xr = cell2mat(cellfun(@(a) kron(a(1:m),a(m+1:p+m)), num2cell(XR, 2),'UniformOutput', false));
elseif way == 3 
    %%%%%%method 3%%%%%
    temp_xr = zeros(n,m*p);
    % parfor i=1:n
    for i=1:n        
            temp_xr(i,:) = kron(R(i,:), X(i,:));
    end
elseif way ==4 
    %%%%%%%method 4%%%%
    temp_xr = []; % of size nx(m*p)
    for k = 1:m
            temp_xr = [temp_xr, bsxfun(@times, X, R(:,k))];
    end
end
% % Add some small random noise to zero rows of temp_xr
% for i = 1:n
%     if sqrt(sum(temp_xr(i,:).^2, 2)) == 0
%         temp_xr(i,:) = 1e-6*rand(1,m*p);
%     end
% end
        

% project each data point to a sphere 
normed_xr = bsxfun(@rdivide, temp_xr, max(1e-5, sqrt(sum(temp_xr.^2, 2)))); % if an observation row is zero, the projected point should be zero

% Then use PCA to the projected points
cov_xr = cov(normed_xr);
[V,~] = eigs(cov_xr, 1);
% Form the 1st vector
V = reshape(V, p, m);



end