function [depth_polished, rawobj] = Funct_01DepthVal_zeta(X, R, V, zeta)
%==========================================================================
% This function computes the polished depth value using a smooth phi constructed 
% by aux_Phi with zeta as the parameter
%------------------------ Input Variables ---------------------------------
% X               - design matrix
% R               - residual matrix
% V               - The normal direction of the half-space 
% zeta            - The parameter used to control the shape of the phi function
%------------------------ Output Variables ---------------------------------
% depth_polished  - the result of the polished depth (between 0 and 1)
%==========================================================================

[rawobj] = Funct_ObjGradHessian_V(X, [], V, R, zeta); % no need of Xt
depth_polished = rawobj / (2 * size(X,1)) + 0.5; % we are using two-sided phi for polishing

end
