function [stepsize, newx, newf, delta] = Armijo_linesearch(f, d, x, fk, negdelta, initalpha, maxsearches, rho, c, ZeroOut)
if ~exist('c', 'var') || isempty(c)
    c = 1e-4;
end
if ~exist('rho', 'var') || isempty(rho)
    rho = 0.1; % 0.5;
end
if ~exist('maxsearches', 'var') || isempty(maxsearches)
    maxsearches = 5;
end
if ~exist('initalpha', 'var') || isempty(initalpha)
    initalpha = 0.1; % original: 1
end

alphak = initalpha;
xx = x;
x = x + alphak * d;

if ~exist('ZeroOut', 'var')
    ZeroOut =[];
end
ZeroOutEffective = exist('ZeroOut', 'var') && ~isempty(ZeroOut);

if ZeroOutEffective
        x = x .* ZeroOut.mat; 
end
fk1 = feval(f, x);
searches = 1;
if ~ZeroOutEffective || (ZeroOutEffective && strcmpi(ZeroOut.BMethod, 'penalized'))
    while fk1 > fk + c*alphak*(negdelta) && searches <= maxsearches
        alphak = alphak * rho;
        x = xx + alphak * d;
        fk1 = feval(f, x);
        searches = searches + 1;
    end
    delta  = alphak * d;
% elseif strcmpi(ZeroOut.BMethod, 'constrained')
%         % In this case, we actually perform projected gradient descent and the search criterion changes correspondingly. 
%         while fk1 > fk - c/alphak*(norm(x - xx, 'fro')^2) && searches <= maxsearches    
%             alphak = alphak * rho;
%             x = xx + alphak * d;
%             x = x .* ZeroOut.mat; % projection to maintain the zeros
%             fk1 = feval(f, x);
%             searches = searches + 1;
%         end
%         delta  = x - xx;
else
        error('Not implemented');
end

stepsize = alphak;
newx = x; 
newf = fk1;
    
% disp(searches)

