function [VOpt, BOpt, depth] = Func_MaxDepth01_GLMEst(X, Xt, Bs_init, zetaGrid, rhogrid, optsB, optsV, fHandle_GLM_res, ZeroOut)
%==========================================================================
% This function estimates the unknown parameter(s) with maximum depth.
% The optimization is based on a nested algorithm within the annealing process.
%------------------------ Input Variables ---------------------------------
% X               - design matrix  (Xt -- its transpose)
% Bs_init         - the intial values of B
% zetaGrid        - the grid of the steepness (zeta) for successive apporximations of the sign function
% rhogrid         - the grid of the initial (inverse) stepsize parameter in
%                   the annealilng process ( of the same size of that of zetaGrid)
% optsB           - Options for optimizing B
% optsV           - Options for optimizing V
% fHandle_GLM_res - functional handle of the Funct_GLMResidual_Gradient.m
% ZeroOut         - field mat: a binary matrix of the same size of B. 0 means the position should be fixed at 0
%------------------------ Output Variables --------------------------------
% Output the following quantities for the largest steepness zeta
% VOpt            - the estimate of V
% BOpt 	          - the estimate of B
% depth           - 0-1 depth value
%==========================================================================
% zeta            - annealing parameter for the heating oprocess (inverse cooling), which controls
%                   the steepness of the function in approximating the sign function 
%==========================================================================
debug = 0; 

optsB_DA = optsB;
if length(zetaGrid) ~= length(rhogrid)
    error('rho and zeta should be of the same length')
end

if ~exist('ZeroOut', 'var') 
    ZeroOut = [];
end
ZeroOutEffective = exist('ZeroOut', 'var') && ~isempty(ZeroOut);

% Initial Bs are constructed from the estimated Bs of last zeta, the initial Bs of the last zeta or the initial Bs used at the beginning. 
% Initial Vs are constructed from sampling or the V estimates obtained at the last zeta

FirstIter_numOfInitValues_B = optsB.numOfInitValues; % At the first zeta value, how many initial Bs are used in solving the nonconvex opt problem
FirstIter_numOfInitValues_V = optsV.numOfInitValues; % At the first zeta value, given any B, how many initial Vs are used in solving the nonconvex opt problem

LaterIter_numOfInitValues_V = 1; %2  %max( ceil(optsV.numOfInitValues / 10), 1); % 1: use the lst V estimate; otherwise, add more random sampled Vs or previously estimated Vs
LaterIter_numOfInitValues_B = 1; %2  % After the first itration, how many initial Bs are used in solving the nonconvex opt problem
                                 % The (optimal) B estimate at the previous zeta is ALWAYS included.

LaterIter_typeOfInitValues_B = 'lastEsts'; 
%Options for LaterIter_typeOfInitValues_B
% 'lastEsts'             - use the last B estimates to initialize the Bs in remaining iterations (including the optimal B estimate at the previous zeta)
% 'lastInitsReorder'     - the first B is the best estimated Bs and the initial Bs used for the last zeta, ordered  (and the optimal B estimate at the previous zeta)
% 'lastInits'            - the initial Bs used for the last zeta (and the optimal B estimate at the previous zeta)
% 'FirstInits'           - the initial Bs used at the beginning, not ordered (!) (and the optimal B estimate at the previous zeta)
% 'FirstInitsReorder'    - the initial Bs used at the beginning, ordered using the first zeta-function (and the optimal B estimate at the previous zeta)
% 'CombinedEstsAndInits' - the initial Bs that combind with the Estimated B in last zeta and the initial Bs at the beginning (and the optimal B estimate at the previous zeta)

LaterIter_typeOfInitValues_V = 'lastEsts';
%Options for LaterIter_typeOfInitValues_V
% 'lastEsts'             - use the last estimated Vs that correspond to BEts
% 'randomsamples'        - use random sampled Vs 
% 'VOptOrigCandidate'    - use the candidates of VOpt in Func_InAnn_NestedOpt.m to give the initials

zetaGrid = unique(sort(zetaGrid, 'ascend')); 
gridsize = length(zetaGrid);


for i = 1:gridsize
    if debug >= 0
        fprintf('%dth zeta... \n', i)
    end
        
    zeta = zetaGrid(i);
    rho = rhogrid(i);
    optsB_DA.maxiter = optsB.maxiter(i);
    if i == 1        
        Bs_init_InAnn = Bs_init;   
        [BOpt, ~, BEsts, VEsts, Bs_init_reord_InAnn] = Funct_MaxDepth01_InAnn(X, Xt, Bs_init_InAnn, [], FirstIter_numOfInitValues_B, FirstIter_numOfInitValues_V, [], zeta, rho, optsB_DA, optsV, fHandle_GLM_res, ZeroOut);
        Bs_Init_reord = Bs_init_reord_InAnn;
    else
        
%         BOpt, BEsts(last step), Bs_init_reord_InAnn;  Bs_init, Bs_init_reord
%%        construct new Bs_init_InAnn
        switch  LaterIter_typeOfInitValues_B 
            case 'lastEsts' % already ordered
                Bs_init_InAnn = BEsts(:, :, 1:LaterIter_numOfInitValues_B);
            case 'lastInitsReorder' % the initial Bs used for the last zeta, ordered 
                Bs_init_InAnn = cat(3, BOpt, Bs_init_reord_InAnn(:,:, 1:LaterIter_numOfInitValues_B - 1));   
            case 'lastInits' % the initial Bs used for the last zeta
                Bs_init_InAnn = cat(3, BOpt, Bs_init_InAnn(:, :, 1:LaterIter_numOfInitValues_B - 1));
            case 'FirstInits' % the initial Bs used at the beginning, not ordered (!)
                Bs_init_InAnn = cat(3, BOpt, Bs_init(:, :, 1:LaterIter_numOfInitValues_B - 1));
            case 'FirstInitsReorder' % the initial Bs used at the beginning, ordered using the first zeta-function
                Bs_init_InAnn = Bs_Init_reord(:,:, 1:LaterIter_numOfInitValues_B);   
            case 'CombinedEstsAndInits' % the initial Bs that combind with the Estimated B in last zeta and the initial Bs at the beginning
                NumOfBEsts = floor(LaterIter_numOfInitValues_B/2);
                Bs_init_InAnn = cat(3, BEsts(:,:,1:NumOfBEsts), Bs_Init_reord(:,:,1: LaterIter_numOfInitValues_B - NumOfBEsts));
                if mod(LaterIter_numOfInitValues_B,2)==1 && i==2
                    warning('If The Initial Type of B is "CombinedEstsAndInits", we recommend to set "LaterIter_numOfInitValues_B" as an even number')
                end
            otherwise
                error('Not implemented yet')
         end
            
%%        construct new Vs_init_InAnn
        switch  LaterIter_typeOfInitValues_V
           case 'randomsamples'
               Vs_init_InAnn = []; % no V generation before calling the function. 
                                   % (Random Vs will be generated in running Funct_MaxDepth01_InAnn)
           case 'lastEsts'         % use the VEsts to give the initial of V in next iteration, if the number of elements in VEsts is smaller than the number of initial in next iteration, it will filled with random sample automatically. 
               if (LaterIter_numOfInitValues_V <= size(VEsts,3))
                   Vs_init_InAnn = VEsts(:,:,1:LaterIter_numOfInitValues_V);
               else 
                   Vs_init_InAnn = VEsts;
               end
           otherwise
               error('Not implemented yet')
        end
 %%       call the main function       
        
        [BOpt, VOpt, BEsts, VEsts, Bs_init_reord_InAnn] = Funct_MaxDepth01_InAnn(X, Xt, Bs_init_InAnn, Vs_init_InAnn, LaterIter_numOfInitValues_B, LaterIter_numOfInitValues_V, LaterIter_typeOfInitValues_V, zeta, rho, optsB_DA, optsV, fHandle_GLM_res, ZeroOut);


        

 %%                 
        if i == gridsize % Calculate the true 0-1 depth
            R = fHandle_GLM_res(X, BOpt);
%             depth = Funct_01DepthVal(X, R, VOpt);
            depth = Func_PHD01(X, R, Xt, zetaGrid, optsV, ZeroOut);

            if optsB.output > 0
              fprintf('Final depth is %.2f.  \n', depth)
            end
        end
    end
end
end




function [BOpt, VOpt, BEsts, VEsts, Bs_init_reord] = Funct_MaxDepth01_InAnn(X, Xt, Bs_init_InAnn, Vs_init_InAnn, numOfInitValues_B, numOfInitValues_V, LaterIter_typeOfInitValues_V, zeta, rho, optsB_DA, optsV, fHandle_GLM_res, ZeroOut)
%==========================================================================
% This function apply the annealing process with the nested algrithom in
% this process. The function value of the 
%------------------------ Input Variables ---------------------------------
% X                  - design matrix
% Xt                 - transpose of X
% Bs_init            - the intial values of B
% Vs_init            - the intial values of V
% numOfInitValues_B  - the number of initials of B
% numOfInitValues_V  - the number of initials of V
% zeta               - steepness for the apporximation of the sign function
% rho                - the step size of BCD in nested algrithom
% optsB_DA           - Options for optimizing over the fit B using Directional Ascent         
% optsV              - options for V optimization
% fHandle_GLM_res    - functional handle of the Funct_GLMResidual_Gradient.m
% ZeroOut         - field mat: a binary matrix of the same size of B. 0 means the position should be fixed at 0
%------------------------ Output Variables ---------------------------------
% BOpt             - Finial result of B
% VOpt             - Finial result of V
% BEsts            - The solutions of Bs after optimization
% VEsts            - The solutions of Vs after optimization
% Bs_rank          - The rank of inital Bs baced on the function value
%==========================================================================
debug = 0; 
[p, m, ~]= size(Bs_init_InAnn);
noInitV = ~exist('Vs_init_InAnn', 'var') || isempty(Vs_init_InAnn);

if ~exist('ZeroOut', 'var')
    ZeroOut =[];
end
ZeroOutEffective = exist('ZeroOut', 'var') && ~isempty(ZeroOut);

if ZeroOutEffective && sum((size(ZeroOut.mat))==[p,m]) ~= 2
    error('wrong dimention for ZeroOut.mat')
end

if noInitV == 1 || ~exist('LaterIter_typeOfInitValues_V', 'var') || isempty(LaterIter_typeOfInitValues_V)
    typeOfInitValues_V = 'Randomsamples';
elseif strcmpi(LaterIter_typeOfInitValues_V, 'lastEsts') && numOfInitValues_V <= size(Vs_init_InAnn, 3)
    typeOfInitValues_V = 'LastEsts';
elseif strcmpi(LaterIter_typeOfInitValues_V, 'lastEsts') && numOfInitValues_V > size(Vs_init_InAnn, 3)
    typeOfInitValues_V = 'LastEstsAndRsamples';
else
    error("Something wrong with Initial V")
end

%%deal with the situation that Vs_init or numOfInitValues_V is not given and
%%numOfInitValues_V is not reasonal
if ~exist('numOfInitValues_V', 'var') || isempty(numOfInitValues_V)
    numOfInitValues_V = 1;
end

%%deal with the situation that numOfInitValues_B is not given or it is not
%%reasonal
if ~exist('numOfInitValues_B', 'var') || isempty(numOfInitValues_B)
    [~,~,numOfInitValues_B] = size(Bs_init_InAnn);
elseif  size(Bs_init_InAnn,3)< numOfInitValues_B
    warning('numOfInitValues_B should be smaller or equal to number of initial Bs')  
    [~,~,numOfInitValues_B] = size(Bs_init_InAnn);
end



BEsts = zeros(p, m, numOfInitValues_B);
VEsts = zeros(p, m, numOfInitValues_B);
DepthEsts = zeros(numOfInitValues_B, 1);
if nargout == 5
    Bint_fres = zeros(numOfInitValues_B, 1);
end
for j = 1:numOfInitValues_B
% Given each initial B, we generate multiple initial V's to call the main depth algorithm
    Vres = zeros(p, m, numOfInitValues_V);
    Bres = zeros(p, m, numOfInitValues_V);
    Bopt_fres = zeros(numOfInitValues_V, 1);
    R_init = fHandle_GLM_res(X, Bs_init_InAnn(:,:,j)); %Funct_GLMResidual(Y, X, B_init, family);
    switch typeOfInitValues_V
        case 'Randomsamples'
            Vs_init = Funct_InitVs(Xt, R_init, numOfInitValues_V, ZeroOut);
        case 'LastEsts'
            Vs_init = Vs_init_InAnn; %(:,:,j);
        case 'LastEstsAndRsamples'
            Vs_init = cat(3, Vs_init_InAnn, Funct_InitVs(Xt, R_init, numOfInitValues_V-size(Vs_init_InAnn, 3), ZeroOut));
    end
    for k = 1:numOfInitValues_V
        V_init = Vs_init(:, :, k);
        if debug > 0, disp('Optimizing B given V:'), end
        [Vres(:,:,k), Bres(:,:,k), Bopt_fres(k)] = Func_InAnn_NestedOpt(X, Xt, V_init, Bs_init_InAnn(:,:,j), zeta, rho, optsB_DA, optsV, fHandle_GLM_res, ZeroOut);     
    end
    optInd = find(Bopt_fres == min(Bopt_fres), 1);             
    BEsts(:, :, j) = Bres(:, :, optInd);
    VEsts(:, :, j) = Vres(:, :, optInd);
    DepthEsts(j) = Bopt_fres(optInd); 
    % This is the 2nd output of Funct_01DepthVal_zeta(X, fHandle_GLM_res(X, BEsts(:, :, j)), VEsts(:, :, j), zeta)
    % If we use the 0-1 depth value in [0, 1]: it should be:  Funct_01DepthVal(X, fHandle_GLM_res(X, BEsts(:, :, j)), VEsts(:, :, j))             
    % ([Q]: Is using the objective value of 0-1 depth better than the current zeta-indexed function?)
    if nargout >= 5
       Bint_fres(j) = Funct_01DepthVal_zeta(X, R_init, VEsts(:, :, j), zeta); % the 1st output is the raw f-value. 
       % Since Bint_fres is only used for comparison, the 2nd output is fine too.
    end  
end
[DepthEsts, sortBsInd] = sort(DepthEsts, 'descend');
VEsts = VEsts(:, :, sortBsInd);
BEsts = BEsts(:, :, sortBsInd);
VOpt = VEsts(:,:,1);
BOpt = BEsts(:,:,1);
if nargout >= 5
    [~, sortBinitsInd] = sort(Bint_fres, 'descend');
    Bs_init_reord = Bs_init_InAnn(:, :, sortBinitsInd);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
 R = fHandle_GLM_res(X, BOpt);
 depth = Funct_01DepthVal(X, R, VOpt);
 depthzeta = Funct_01DepthVal_zeta(X, R, VOpt, zeta);
 if debug > 0,  fprintf('the 0-1 depth is %.2f, approximate depth is %.2f, f/n value is %.2f \n' , depth, depthzeta, DepthEsts(1)/size(X,1)), end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

end
