function [f, g] = Funct_ObjGrad_V_RRR_Depth(X, Xt, V, R, P_perp, L, Q_perp, zeta, rho_depth)
%==========================================================================
% This function computes the function value and gradient (wrt V) of the objective 
% function in computing polished RRR depth
n = size(X, 1);
[objvec, S] = aux_Obj_RRR_Depth_objvec(X, V, R, P_perp, L, Q_perp, rho_depth);
f = sum(aux_Phi(objvec, zeta));

% [depth_polished_zeta, ~, objvec] = Funct_Obj_RRR_Depth(X, V, R, P_perp, L, Q_perp, zeta, rho_depth, 0);

if nargout > 1
    [~, g1] = aux_Phi(objvec, zeta);
    g = (1 / rho_depth) * Xt * bsxfun(@times, R, g1) + sum(g1) * S / n; %X.'*diag(g1)*R  for V
end
