function[optsVOpt] = Funct_ParamsConfiguration(problemsize, tol, tolgrad, maxiter, numOfInitValues, alpha, method)
%==========================================================================
% This function constructs some default parameters in calling each optimization method
%------------------------ Input Variables ---------------------------------
% tol               - the difference between last function value and
%                     current function value when convergence
% tolgrad           - total forbinis norm for gradient when convergence
% maxiter           - residual matrix
% numOfInitValues   - total iterative number limit
% alpha             - the initial value rho divided by L
% method            - the options for certain method
%------------------------ Output Variables --------------------------------
% optsVOpt          - the constrcted options for certain method
%==========================================================================
n = problemsize(1); p = problemsize(2); m = problemsize(3);
if  ~exist('method', 'var') || isempty(method) 
    if n <= 1000 && p * m < 500  
        method  =  'Manopt:tr'; 
    elseif  n <= 1000 &&  p * m >= 500
        method  =  'SAP:2ndAcc';
    else % n > 10000
        method  =  'Manopt:rlbfgs';
    end
end
if  ~exist('alpha', 'var') || isempty(alpha)
    alpha.pr = 1e-10;
    alpha.apr = 1e-10;
    alpha.rgg = 0;
    alpha.acc = 10^-(floor(log10(n/5)) + 3 + floor(log10(p)));%(10^(-0.002213*n - 3.819672));  %10^-(ceil(log10(n))+2 + floor(log10(p-1/10))); %1.0*(1e-6); %(10^(-0.002213*n - 3.819672)); %1.0*(1e-6); %10^-(ceil(log10(n))+2 ); %(10^(-0.002213*n - 3.819672));  %10^-(ceil(log10(n))+2 + ceil(log10(p-1/10))); %10^( -0.002213*n - 3.819672 - floor(log10(m/10)) ); %(10^(-0.002213*n - 3.819672)); %1.0*(1e-5); %1.0*(1e-6);   %2400; %46400;  %1.823e+3; %1e+4*alpha.pr; %1e+5*alpha.pr; 
else
    alpha.pr = alpha;
    alpha.apr = alpha;
    alpha.rgg = alpha;
    alpha.acc = alpha;   %2400; %46400;  %1.823e+3; %1e+4*alpha.pr; %1e+5*alpha.pr;  
end

optsVOpt.maxiter = maxiter;
optsVOpt.numOfInitValues = numOfInitValues;
switch method
    case {'Manopt:tr', 'Manopt:cg', 'Manopt:bb', 'Manopt:rlbfgs'}
        optsVOpt.scheme = 'ManOpt';
        %optsV.checkgrad = 'true';
        %optsV.checkhess = 'true';
        optsVOpt.verbosity = 0;
        optsVOpt.tolgradnorm = tolgrad;
        optsVOpt.usehess = 'true';
        optsVOpt.alpha = []; 
    case {'SAP:pr0', 'SAP:pr1'}
        optsVOpt.scheme = 'SAP:pr';
        optsVOpt.tol = tol;
        optsVOpt.tolgrad = tolgrad;        %In order to make the comparison fair between prox methods
        %and manifold optimization, we use the following as the
        %stopping criterion
        %The norm of the Riemannian gradient
        optsVOpt.alpha = alpha.pr;        %Search the step-size starting from 1/(alpha*L)
    case {'SAP:apr0', 'SAP:apr1'}
        optsVOpt.scheme = 'SAP:Apr';
        optsVOpt.tol = tol;
        optsVOpt.tolgrad = tolgrad;
        optsVOpt.alpha = alpha.apr;
    case {'SAP:2ndAcc'}
        optsVOpt.scheme = 'SAP:2ndAcc';
        optsVOpt.tol = tol;
        optsVOpt.tolgrad = tolgrad;
        optsVOpt.alpha = alpha.acc;
        optsVOpt.search_number = 3; % suffices
        optsVOpt.beta = 4;
    case {'SAP:rgg0', 'SAP:rgg1'}
        optsVOpt.scheme = 'SAP:Rgg';
        optsVOpt.tol = tol;
        optsVOpt.tolgrad = tolgrad;
        optsVOpt.alpha = alpha.rgg;
    otherwise
        error('Not implemented.')
end
% Further details
switch method
    case 'Manopt:tr'
        optsVOpt.ManoptMethod = 'trustregion';
        optsVOpt.usehess = 'TRUE';
    case 'Manopt:cg'
        optsVOpt.ManoptMethod = 'conjugategradient';
    case 'Manopt:bb'
        optsVOpt.ManoptMethod = 'barzilaiborwein';
    case 'Manopt:rlbfgs'
        optsVOpt.ManoptMethod = 'rlbfgs';
    case {'SAP:pr0', 'SAP:apr0', 'SAP:rgg0'}
        optsVOpt.linesearch = 'FLASE'; 
    case {'SAP:pr1', 'SAP:apr1', 'SAP:rgg1', 'SAP:2ndAcc'}
        optsVOpt.linesearch = 'TRUE';
end

end