%% This is a demo for computing RRR data depth on the stock dataset
clear;  clc;
addpath(genpath(pwd)) % include the directory into Matlab path
rng('default')
rng(0)
mypath = pwd; 

%% Load data 
data = dlmread([mypath, '\stock_data', '.txt'], '\t'); 
X = data(:,1:9);
Y = data(:,10:18);
% dlmwrite([mypath, '\stock_data', '.txt'], data, '\t');

lossType = 'Gaussian';
r = 6;

% load all the estimates
load('stock_data_Bests.mat'); 
BTarget =  B_R4; % B_RRR; % B_CRRR; % B_DRRR;
fprintf('The rank of given point is: %i, the rank parameter for the RRR-depth is: %i. \n', rank(BTarget),  r);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Calculate the rank-r data depth of the given (matrix) estimate
fprintf('================================================================================ \n');
% First, we construct the R matrix
R = - Funct_GLMResidual_Gradient(Y, X, BTarget, lossType); 
% Then call the Func_RRR_Depth function  
opts = struct('V_method', '2ndAcc', 'L_method', '2ndAcc', 'numOfInitValues', 10, 'maxiter', 3e+3, 'tolgrad', 1e-5, 'tol', 1e-3, 'V_tol', 1e-4, 'L_tol', 1e-4, 'V_bcd_maxiter', 100, 'L_bcd_maxiter', 100);
rho_depth =  0.001 * norm(X, 2)^2; 
[depthval, time, Vopt, Lopt_unscaled] = Func_RRR_Depth(X, Y, BTarget, R, r, [], opts, rho_depth);  % the parameter zetaGrid takes the default


fprintf('=============================   RESULTS   ======================================= \n');
fprintf('The depth value of the given point is %.4f. \n', depthval);
