function [X, final_cost, info, t] = Func_2ndAcc_univ(X_init, L, funObj, funProj, opts)
%==========================================================================
% This function performs the 2nd accelerated proximal gradient with line
% search.
%------------------------ Input Variables ---------------------------------
% X_init          - the starting value of unknown X
% L               - Upper bound of the lipschitz constant
% funObj          - The objective function the 
% funProj         - The projection function for constrain cases
% opts            - options for optimization
%------------------------ Output Variables ---------------------------------
% X               - the final iterate
% final_cost      - final function value at convergence
% info 	          - some information of the final iteratve (func val, gradient)
% t               - the number of iterations
%==========================================================================
linesearch_criterion = 'MaxRScaled'; % 'lastR'; %'MaxR' %  

if ~isfield(opts, 'search_number')
    opts.search_number = 3;
end

if ~isfield(opts, 'tolgrad')
    opts.tolgrad = 1e-4;
end

[p, m] = size(X_init);
W_cur = zeros(p, m, opts.search_number);
V_cur = zeros(p, m, opts.search_number);

f = zeros(1,opts.maxiter);
g = zeros(1,opts.maxiter);  %gradnorm

V_old = X_init;
W_old = V_old;            
alpha = opts.alpha;
beta = opts.beta;
rho_min = L * alpha;    %rho_min = alpha;  %rho_old = L * alpha;

for t = 0 : opts.maxiter - 1
    lsCritvals = -1;  % line search criterion value
    rho_cur = rho_min;     %rho_cur=rho_old;

    for i = 1:opts.search_number 
        if i > 1
            rho_cur(i) = beta * rho_cur(i - 1);   
        end
        if t >= 1
            theta_cur(i) = (theta_old * sqrt(rho_old) * sqrt(rho_old * theta_old ^ 2 + 4 * rho_cur(i)) - rho_old * theta_old^2) / (2 * rho_cur(i)); %6
        else
            theta_cur(i) = 1;
        end
        U = (1 - theta_cur(i)) * V_old + theta_cur(i)* W_old;     

        [fz, gz] = funObj(U);

        W_cur(:, :, i) = W_old - gz / (theta_cur(i) * rho_cur(i)); 
        
        W_cur(:, :, i) = funProj(W_cur(:, :, i)); 

        V_cur(:, :, i) = (1 - theta_cur(i)) * V_old + theta_cur(i) * W_cur(:, :, i);  

        R_t = theta_cur(i) ^ 2 * rho_cur(i) * norm(W_cur(:, :, i) - W_old, 'fro') ^ 2 / 2 - Delta(V_cur(:, :, i), U, funObj, fz, gz) + (1 - theta_cur(i)) * Delta(V_old, U, funObj, fz, gz); 

        switch linesearch_criterion
            case 'MaxRScaled'
                lsCritvals(i) = R_t / (rho_cur(i) * theta_cur(i) ^ 2 );
            case 'MaxR'
                lsCritvals(i) = R_t;
            case 'lastR'
                lsCritvals(i) = R_t;
%                 if i == opts.search_number 
%                     lsCritvals(i) = Inf;
%                 end
                %lscrit = sort(lscrit, 'ascend'); % to make sure the largest number is the last element of the array

            otherwise
                error('not impliment yet')
        end

        if lsCritvals(i) >=0
            break
        end
    end
    if strcmp(linesearch_criterion, 'lastR')
        index = i;
    else
        [~,index] = max(lsCritvals);
    end
    rho_old = rho_cur(index);
    theta_old = theta_cur(index);
    W_old = W_cur(:, :, index);
    V_old = V_cur(:, :, index);

    % Check stopping criteria
    f(t+1) = fz;
    g_old_proj = gz - sum(sum(W_old.*gz,2))*W_old;
    g(t+1) = norm(g_old_proj,'fro');

    if t > 0 && ( g(t+1) < opts.tolgrad || abs(f(t+1) - f(t)) < opts.tol )    
    f = f(1:t+1);
    g = g(1:t+1);
    break
    end

end
X = V_old;
final_cost = f(end);
info.cost = f;
info.gradnorm = g;
t=t+1;
end

function[value] = Delta(V, U, funObjGrad, fz, gz)
%==========================================================================
% This function caluates the generalized Bregman function
%==========================================================================
[f1] = funObjGrad(V);
diff = V - U;

cond1 = ~exist('fz', 'var') || isempty(fz);
cond2 = ~exist('gz', 'var') || isempty(gz); 
if cond1 && cond2
    [fz, gz] = funObjGrad(U);
elseif cond1 && ~cond2
    [fz] = funObjGrad(U);
elseif ~cond1 && cond2
    [fz, gz] = funObjGrad(U);
end

value = f1 - fz - sum(sum(gz.*diff, 2));
end




