function [R, G] = Funct_GLMResidual_Gradient(Y, X, B, family)
%==========================================================================
% This function computes the residual matrix R, and its gradient as a 
% function of the systematic component (mu, not B), in the GLM family
%------------------------ Input Variables ---------------------------------
% Y               - multivariate observations
% X               - design matrix
% B               - the fitted coefficient matrix
% family          - GLM family, gaussian or poisson
%------------------------ Output Variables --------------------------------
% R               - the residual matrix
% G               - the negative gradient of the residual matrix wrt the
%                   systematic component mu
%==========================================================================

Theta = X*B; 
mu = Funct_GLM_mean(Theta, family);
R = Y - mu;

if nargout == 2

        switch lower(family)
            case 'gaussian'
                    G = - 1;     % grad R(mu)
                    % G will be used in the nested algorithm (for pursuing 
                    % a deep B) to compute the gradient wrt B; see the
                    % paper for more details.
            case 'poisson'
                    G = - exp(Theta);
            case 'binomial'
                    temp = exp(- Theta);
                    G = - temp/(1 + temp)^2; 
            otherwise
                error('not implemented yet');
        end

    
end
end
%Utility: GLMR = @(X, B) Funct_GLMResidual_Gradient(Y, X, B, family);
