function [X, Y] = Funct_geneGLMData(dataName, n, p, BTrue, addoutlier, family)
%%%%%%%%%%%%%%%%%%%%%%%% Simulation data generation %%%%%%%%%%%%%%%%%%%%
% This functions is used to generate some simulation data
p = p - 1;
if strcmp(dataName(1:2), 'my')
    if strcmp(dataName, 'myunif')
        X = rand(n, p); X(X<=.25) = -1; X(X>.25 & X <= .75) = 0; X(X>.75) = 1;
    elseif strcmp(dataName, 'myunif-allequal')
        X = unifrnd(-10, 10, n, p);
        rou=0.5;
        corrMat = rou .^ (ones(p, p) - diag(ones(1,p)));
        X = X * chol(corrMat);
    elseif strcmp(dataName, 'mynorm-iid')
        X = randn(n, p);
        rou=0;
        corrMat = rou .^ abs([1:p]' * ones(1, p) - ones(p, 1) * [1:p]);
        X = X * chol(corrMat);
    elseif strcmp(dataName, 'mynorm-highcorr')
        X = randn(n, p);
        rou=.9;
        corrMat = rou .^ abs([1:p]' * ones(1, p) - ones(p, 1) * [1:p]);
        X = X * chol(corrMat);
    elseif strcmp(dataName, 'mynorm-medcorr')
        X = randn(n, p);
        rou=.5;
        corrMat = rou .^ abs([1:p]' * ones(1, p) - ones(p, 1) * [1:p]);
        X = X * chol(corrMat);
    elseif strcmp(dataName, 'mynorm-mildcorr')
        X = randn(n, p);
        rou=.1;
        corrMat = rou .^ abs([1:p]' * ones(1, p) - ones(p, 1) * [1:p]);
        X = X * chol(corrMat);
    elseif strcmp(dataName, 'mynorm-allequal')
        X = randn(n, p);
        rou=.5;
        %        rou=0.9;
        corrMat = rou .^ ones(p)+ (1-rou) * eye(p);
        X = X * chol(corrMat);
    else
        error('Wrong data name')
    end
    switch lower(family)
        case 'gaussian'
            X_circle = X;
        case 'poisson'
            scale = p/2; %5*round(p/10);
            X_circle = X/scale;
        case 'binomial'
            X_circle = X;
        otherwise
            error('Wrong GLM family')
    end
    
    %% Add in outliers
    highLevNum = ceil(n * addoutlier.Pct);
    outliersNum = ceil(n * addoutlier.Pct);
    Alpha =  ones(n,1)*BTrue(1,:);
    L = addoutlier.levStrength;
    X_circle(1:highLevNum,:) = L;  % make the first highLevNum observations as highly leveraged points
    [~, m] = size(BTrue);
    systematiccomponents = X_circle*BTrue(2:end,:);
    [~, index] = sort(abs(systematiccomponents),'descend');
    index = index(1:outliersNum);
    OutlierY = zeros(n,m);
    OutlierY(index) = -addoutlier.outlierStrength*systematiccomponents(index);
    switch lower(family)
        case 'gaussian'
            Y = randn(n, m) + systematiccomponents + OutlierY + Alpha;
        case 'binomial'
            Y = binornd(1, 1./(1+exp(- systematiccomponents - OutlierY -  Alpha)));
        case 'poisson'
            Y = poissrnd(exp(systematiccomponents + OutlierY +  Alpha));
        otherwise
            error('not implemented yet');
    end
else
    error('not implemented yet')
end
X = [ones(n,1),X_circle];
end



