function Q2r=essential_closestRepresentative(Q1,Q2,varargin)
[tMin,~,Q2]=essential_distMinAngle(Q1,Q2,varargin{:});
NQ1=size(Q1,3);
NQ2=size(Q2,3);

if NQ1>1 && NQ2==1
    Q2=repmat(Q2,[1 1 NQ1]);
end
NQ=max(NQ1,NQ2);

Q2r=zeros(size(Q2));
for iQ=1:NQ
    t=tMin(iQ);
    Rz=[cos(t) -sin(t) 0; sin(t) cos(t) 0; 0 0 1];
    Q2r(1:3,1:3,iQ)=Rz*Q2(1:3,1:3,iQ);
    Q2r(4:6,1:3,iQ)=Rz*Q2(4:6,1:3,iQ);
end
