function [f, g] = Funct_GLMLoss_Gradient(betas, X, y, regparam, family)
%==========================================================================
% This function computes the value of the loss function (provided by the user, used to induce data depth) 
% and its gradiant (wrt B)
%------------------------ Input Variables ---------------------------------
% betas           - the parameter of the GLM model
% X               - Design matrix
% y               - multivariate observations
% regparam          - tuning parameters for the l2 panalty
% family          - GLM family, gaussian or poisson
%------------------------ Output Variables --------------------------------
% f               - the value of the loss function
% g               - the gradient of the loss function 
%==========================================================================

if size(y, 2) == 1
    switch lower(family)
       case {'binomial'}
    %       val = -y'*(X*betas+alphas) + sum(log(1+exp(X*betas+alphas))); %get Inf if X*betas+alphas>800
          eta = X * betas; % val = -y'*(eta) + sum(eta(eta>500)) + sum(log(1+exp(eta(eta<=500))));
          val = -y'*eta;
          for i = 1:size(betas,2)
              val(i) = val(i) + sum((eta(:,i)>500) .* eta(:,i)) + sum(log(1+exp(eta(eta(:,i)<=500, i))));
          end

       case 'poisson'
          val = -y'*(X*betas) + sum(exp(X*betas));
       case 'gaussian'
           %scaled -- assume sigma=1
          val = sum((y * ones(1, size(betas,2)) - X * betas).^2)/2;  
       otherwise
          error('not implemented yet')
    end
    
    f = val + regparam*sum(betas(2:end).^2)/2 ;  
    if nargout == 2
       Theta = X*betas;
       mu = Funct_GLM_mean(Theta, family); 
       g = X.'*(mu-y) + regparam*[0;betas(2:end)]; 
    end
    
else
    oriBetas = betas;
    oriYs = y;
    val = 0;
    switch lower(family)
        case {'binomial'}
            for iResp = 1:size(oriBetas,2)
                betas = squeeze(oriBetas(:, iResp, :));
                y = oriYs(:, iResp);
                %val = -y'*(X*betas+alphas) + sum(log(1+exp(X*betas+alphas))); %get Inf if X*betas+alphas>800
                eta = X * betas; % val = -y'*(eta) + sum(eta(eta>500)) + sum(log(1+exp(eta(eta<=500))));
                tval = -y'*eta;
                for i = 1:size(betas,2)
                  tval(i) = tval(i) + sum((eta(:,i)>500) .* eta(:,i)) + sum(log(1+exp(eta(eta(:,i)<=500, i))));
                end
                val = val + tval;
            end
        case 'poisson'
            for iResp = 1:size(oriBetas,2)
                betas = squeeze(oriBetas(:, iResp, :));
                y = oriYs(:, iResp);           
                tval = -y'*(X*betas) + sum(exp(X*betas));
                val = val + tval;
            end
        case 'gaussian'
            for iResp = 1:size(oriBetas,2)
                betas = squeeze(oriBetas(:, iResp, :));
                y = oriYs(:, iResp);
                %scaled -- assume sigma=1
                tval = sum((y * ones(1, size(betas,2)) - X * betas).^2)/2; 
                val = val + tval;
            end
        otherwise
          error('not implemented yet')
    end
    
    f = val + regparam*sum(sum(betas(2:end,:).^2))/2 ;
    if nargout == 2
       Theta = X*betas;
       mu = Funct_GLM_mean(Theta, family); 
       aux_B = betas;
       aux_B(1,:) = zeros(m,1);
       g = X.'*(mu-y) + regparam*aux_B;
    end
end

end