# Simulated cases
## loading packages
#------ Check if package "pacman" is already installed 
lookup_packages <- installed.packages()[,1]
if(!("pacman" %in% lookup_packages))
  install.packages("pacman")


#------ To be installed or loaded
pacman::p_load(magrittr)
pacman::p_load(tidyverse)
pacman::p_load(devtools)
## package for "generateMachines"

## Correlated explanatory variables

meths = c("grid", "GD")
kerns = c("gauss", "gaussian")
cln = c("lars", "ridge", "knn", "tree", "rf", "xgb", "COBRA", kerns,"COBRA.T", paste0(kerns,".T"))

### function to generate inputs
pacman::p_load(MASS)
input <- function(n, d, correlated = TRUE){
  if(correlated){
    Sig <- matrix(0, d, d)
    for(j in 1:d){
      Sig[j,] <- 2^(-abs(j-1:d))
    }
    x <- mvrnorm(n, mu=rep(0,d),Sigma = Sig)
  } else{
    x <- matrix(runif(d * n, -1, 1), nrow = n, ncol = d)
  }
  return(x)
}

### function to generate response variable

response <- function(x, model = 1){
  if(model == 1){
    y <- (x[,1])^2 + exp(-(x[,2])^2)
  }
  if(model == 2){
    y <- x[,1]*x[,2] + (x[,3])^2 - x[,4]*x[,7] + x[,8]*x[,10] - (x[,6])^2 + rnorm(n1,0,0.5)
  }
  if(model == 3){
    y <- -sin(2*x[,1]) + (x[,2])^2 + x[,3] - exp(-x[,4]) + rnorm(n1, 0, 0.5)
  }
  if(model == 4){
    y <- x[,1] + (2*x[,2]-1)^2 + sin(2*pi*x[,3])/(2-sin(2*pi*x[,3])) + sin(2*pi*x[,4]) + 
      2*cos(2*pi*x[,4]) + 3*(sin(2*pi*x[,4]))^2 + 4*(cos(2*pi*x[,4]))^2 + rnorm(n1,0,0.5)
  }
  if(model == 5){
    y <- as.numeric(x[,1]>0)+(x[,2])^3+as.numeric(x[,4]+x[,6]-x[,8]-x[,9]>1+x[,14])+exp(-(x[,2])^2) + rnorm(n1,0,0.5)
  }
  if(model == 6){
    y <- rowSums(((x[,1:10])^3 < 0)) - as.numeric(rnorm(n1) > 1.25)
  }
  if(model == 7){
    y <- (x[,1])^2+(x[,2])^2*x[,3]*exp(-abs(x[,4]))+x[,6]-x[,8]+rnorm(n1, 0, 0.5)
  }
  if(model == 8){
    y <- as.numeric(x[,1]+(x[,4])^3+x[,9]+sin(x[,12]*x[,18])+rnorm(n1,0,0.1)>0.38)
  }
  if(model == 9){
    y <- x[,1]+3*(x[,3])^2-2*exp(-x[,5])+x[,6]
  }
  if(model == 10){
    temp = 0
    for(j in 2:d1){
      temp <- temp - 2*sin((x[,j])) + cos((x[,j])) - exp(-abs(x[,j]))
    }
    y <- exp(x[,1])+exp(-x[,1])+temp
  }
  return(y)
}

# importing function from github

devtools::source_url("https://raw.githubusercontent.com/hassothea/AggregationMethods/main/KernelAggReg.R")

# An exmaple for model 1, the rest can be done the same way
n <- 800; d <- 50
x <- input(n, d)
y <- response(x, model = 1)

train <- vector(length = n)
train[sample(n, 0.8*n)] <- TRUE

agg <- kernelAggReg(train_design = x[train, ],
                    train_response = y[train],
                    test_design = x[!train, ],
                    test_response = y[!train],
                    machines = c("lasso", "ridge", "knn", "tree", "rf"),
                    splits = .5,
                    n_cv = 10,
                    kernels = c("naive", "epan", "biw", "triw", "gaussian"),
                    optimizeMethod = c("grid", "grid", "grid", "grid", "grad"),
                    setBasicMachineParam = setBasicParameter(k = 5,
                                                             ntree = 300),
                    setGradParam = setGradParameter(max_val = 3,
                                                    rate = 1,
                                                    print_step = TRUE),
                    setGridParam = setGridParameter(max_val = 2.5,
                                                    n_val = 500))

agg$mse
